% Showing the results (positon of the interface) of example 1
% TO 091224

load name            % get basename of this model
load(basename);      % load data for this model (generaged in mf_adapt

[xGr,yGr,zGr,xm]=modelsize3(xGr,yGr,zGr); % get xm

[NROW,NCOL,NLAY]=size(IBOUND);  % get size of model

H  =readDat([basename,'.HDS']);  % use only H.totim
ZTA=readBud([basename,'.ZTA']);  % get interface positions

NT=length(ZTA);      % total number of time steps in ZTA file

%% Figure of rotating interface

% setup figure
figure; hold on
xlabel('x [m]'); ylabel('z [m]'); grid on;
title('basename, rotation of interface');

% plot all interface positions
leg{NT}=' '; % allocate leg cell array
clr='brgkcmy'; clr=repmat(clr,1,ceil(NT/length(clr))); % enough colors just in case
for it=1:NT          % for all recoreds in bud file (and H-file)
    for iLay=1:NLAY  % we only have one layer in this case
    plot(xm,squeeze(ZTA(it).term{1}(1,:,iLay)),clr(it));
    leg{it}=sprintf('T=%.0f d',H(it).totim);
    end
end
legend(leg);
